//+----------------------------------------------------------------------------+
//|                                                     fromHistoryInFile.mq4  |
//|                                                                            |
//|                                                      . aka KimIV  |
//|                                                       http://www.kimiv.ru  |
//|                                                                            |
//|  04.11.2007           . |
//+----------------------------------------------------------------------------+
#property copyright "  . aka KimIV"
#property link      "http://www.kimiv.ru"
#property show_inputs

#import "kernel32.dll"
  int GetUserDefaultLCID();
  int GetLocaleInfoA(
    int    Locale,      // locale identifier
    int    LCType,      // type of information
    string lpLCData,    // address of buffer for information
    int    cchData      // size of buffer
  );
#import

//+------    -------------------------------------------+
extern bool bCommission = False;       //  
extern bool bSwap       = True;        //  
extern bool bComment    = True;        //  
extern bool bMagic      = True;        //  MagicNumber

// LCTYPE Constants
#define LOCALE_SDECIMAL 0x000E // Characters used for the decimal separator.

//+----------------------------------------------------------------------------+
//|  script program start function                                             |
//+----------------------------------------------------------------------------+
void start() {
  int    dg, i, k=OrdersHistoryTotal();
  string FileName=DoubleToStr(AccountNumber(), 0)+".csv", st;

  FileDelete(FileName);
  st="Ticket;Open Time;Type;Lots;Item;Price;SL;TP;Close Time;Price";
  if (bCommission) st=st+";Commission";
  if (bSwap) st=st+";Swap";
  st=st+";Profit";
  if (bMagic) st=st+";Magic";
  if (bComment) st=st+";Comment";
  WritingLineInFile(FileName, st);
  for (i=0; i<k; i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_HISTORY)) {
      if (OrderType()<2) {
        dg=   MarketInfo(OrderSymbol(), MODE_DIGITS);
        st=   DoubleToStr(OrderTicket(), 0)+";";
        st=st+TimeToStr(OrderOpenTime(), TIME_DATE|TIME_MINUTES)+";";
        st=st+GetNameOP(OrderType())+";";
        st=st+DoubleToStrLocale(OrderLots(), 2)+";";
        st=st+OrderSymbol()+";";
        st=st+DoubleToStrLocale(OrderOpenPrice(), dg)+";";
        st=st+DoubleToStrLocale(OrderStopLoss(), dg)+";";
        st=st+DoubleToStrLocale(OrderTakeProfit(), dg)+";";
        st=st+TimeToStr(OrderCloseTime(), TIME_DATE|TIME_MINUTES)+";";
        st=st+DoubleToStrLocale(OrderClosePrice(), dg)+";";
        if (bCommission) st=st+DoubleToStrLocale(OrderCommission(), 2)+";";
        if (bSwap) st=st+DoubleToStrLocale(OrderSwap(), 2)+";";
        st=st+DoubleToStrLocale(OrderProfit(), 2)+";";
        if (bMagic) st=st+DoubleToStr(OrderMagicNumber(), 0)+";";
        if (bComment) st=st+OrderComment()+";";
        WritingLineInFile(FileName, st);
      }
      Comment(": ",i+1,"   ",k);
    }
  }
  Comment(" : ",FileName);
}

//+----------------------------------------------------------------------------+
//|                   |
//|      .                                      |
//|  :                                                                |
//|    v -   double                                                   |
//|    d -                                         |
//+----------------------------------------------------------------------------+
string DoubleToStrLocale(double v, int d) {
  if (d<0) d=0;
  if (d>8) d=8;

  string se=GetUserLocale(LOCALE_SDECIMAL), st=DoubleToStr(v, d);
  if (se!=".") st=StrTran(st, ".", se);

  return(st);
}

//+----------------------------------------------------------------------------+
//|                                      |
//|  :                                                                |
//|    op -                                       |
//+----------------------------------------------------------------------------+
string GetNameOP(int op) {
	switch (op) {
		case OP_BUY      : return("Buy");
		case OP_SELL     : return("Sell");
		case OP_BUYLIMIT : return("Buy Limit");
		case OP_SELLLIMIT: return("Sell Limit");
		case OP_BUYSTOP  : return("Buy Stop");
		case OP_SELLSTOP : return("Sell Stop");
		default          : return("Unknown Operation");
	}
}

//+----------------------------------------------------------------------------+
//|  Return of user regional settings.                                         |
//|  Parameters:                                                               |
//|    LCType - type of regional setting (LCTYPE Constant)                     |
//+----------------------------------------------------------------------------+
string GetUserLocale(int LCType) {
  int    loc=GetUserDefaultLCID();
  string str="                                                                ";

  GetLocaleInfoA(loc, LCType, str, 64);

  return(str);
}

//+----------------------------------------------------------------------------+
//|                                                             |
//|  :                                                                |
//|    str     -  ,                   |
//|    strfrom -                                            |
//|    strto   -                                            |
//+----------------------------------------------------------------------------+
string StrTran(string str, string strfrom, string strto) {
  int    n;
  string outstr="", tempstr;

  for (n=0; n<StringLen(str); n++) {
    tempstr=StringSubstr(str, n, StringLen(strfrom));
    if (tempstr==strfrom) {
      outstr=outstr+strto;
      n=n+StringLen(strfrom)-1;
    } else outstr=outstr+StringSubstr(str, n, 1);
  }
  return(outstr);
}

//+----------------------------------------------------------------------------+
//|                                                           |
//|  :                                                                |
//|    FileName -                                                      |
//|    text     -                                                        |
//+----------------------------------------------------------------------------+
void WritingLineInFile(string FileName, string text) {
  int file_handle=FileOpen(FileName, FILE_READ|FILE_WRITE, " ");

	if (file_handle>0) {
    FileSeek(file_handle, 0, SEEK_END);
    FileWrite(file_handle, text);
    FileClose(file_handle);
  }
}
//+----------------------------------------------------------------------------+

